<?php
# zabbix & zabbix-release

$zbx_version = getenv('ZBX_VERSION');
if (!$zbx_version)
	die("ZBX_VERSION environment variable is not defined!\n");
$zbx_version = (float) $zbx_version;

$build_env = getenv('ZBX_BUILD_ENV');
if (!$build_env)
	die("ZBX_BUILD_ENV environment variable is not defined!\n");

$parts = explode('-', $build_env);
if (sizeof($parts) != 3)
	die("Bad build env format '$build_env'!\n");

$dist_name     = $parts[0];
$dist_version  = (int)$parts[1];
$dist_arch     = $parts[2];

$dist_pname = getenv('ZBX_DIST_PNAME');
if(!$dist_pname)
	die("ZBX_DIST_PNAME environment variable is not defined!\n");

$zbx_repourlbase = getenv('ZBX_REPOURLBASE');
if(!$zbx_repourlbase)
	die("ZBX_REPOURLBASE environment variable is not defined!\n");

$zbx_debfullname = getenv('ZBX_DEBFULLNAME');
if(!$zbx_debfullname)
	die("ZBX_DEBFULLNAME environment variable is not defined!\n");

$zbx_debemail = getenv('ZBX_DEBEMAIL');
if(!$zbx_debemail)
	die("ZBX_DEBEMAIL environment variable is not defined!\n");

$major_pre_release = (int)getenv('MAJOR_PRE_RELEASE');

$use_gnutls = ($zbx_version <= 5.0 && $dist_name == 'ubuntu' && ($dist_version == 2204 && $dist_arch == 'x86_64')); # instead of openssl

$use_pcre2 = ( # instead of old pcre
	($zbx_version >= 5.5 && $dist_name == 'debian'    && $dist_version >= 9)    ||
	($zbx_version >= 5.5 && $dist_name == 'raspbian'  && $dist_version >= 9)    ||
	($zbx_version >= 5.5 && $dist_name == 'ubuntu'    && $dist_version >= 1604)
);

$use_libssh = ($zbx_version >= 4.0) && ( # instead of old libssh2
	(($zbx_version == 4.0) &&
		(
			(($dist_name == 'debian' || $dist_name == 'raspbian') && $dist_version == 10) ||
			($dist_name == 'ubuntu' && ($dist_version == 2004 || $dist_version == 1804))
		)
	)
	||
	(($zbx_version > 4.0) &&
		(
			(($dist_name == 'debian' || $dist_name == 'raspbian') && $dist_version >= 10) ||
			($dist_name == 'ubuntu' && $dist_version >= 1804)
		)
	)
);

$got_ssh = ($zbx_version < 6.3) || (
	(($dist_name == 'debian' || $dist_name == 'raspbian') && $dist_version >= 11) ||
	 ($dist_name == 'ubuntu' && $dist_version >= 2004)
);

$use_libssl3 =
	($zbx_version >= 6.0 && $dist_name == 'ubuntu' && $dist_version >= 2204) ||
	($zbx_version >= 6.0 && $dist_name == 'debian' && $dist_version >= 12) ||
	($zbx_version >= 5.0 && $dist_name == 'ubuntu' && $dist_version >= 2404)
;

$use_modbus = ($dist_arch != "ppc64le") && (
	($zbx_version >= 5.5 && $dist_name == 'debian'    && $dist_version >= 11) ||
	($zbx_version >= 5.5 && $dist_name == 'raspbian'  && $dist_version >= 11) ||
	($zbx_version >= 5.5 && $dist_name == 'ubuntu'    && $dist_version == 1604) ||
	($zbx_version >= 5.5 && $dist_name == 'ubuntu'    && $dist_version == 1804) ||
	($zbx_version >= 5.5 && $dist_name == 'ubuntu'    && $dist_version == 2004) ||
	($zbx_version >= 5.5 && $dist_name == 'ubuntu'    && $dist_version >= 2204 && $dist_arch != 'arm64')
);

$use_jabber = ($zbx_version <= 4.0 && $dist_version < 10 && $dist_name != 'raspbian');

$use_curl = $zbx_version < 6.3 ||
	(($dist_name == 'debian' || $dist_name == 'raspbian') &&  $dist_version >= 10) ||
	($dist_name == 'ubuntu' && $dist_version >= 1804);

$rundir = (($zbx_version >= 5.2 || ($dist_name == 'ubuntu' && $dist_version == 2004)) ? '' : '/var').'/run';

$build_agent2 = (!$use_gnutls) && ($zbx_version >= 5.0) &&
	(($dist_arch == 'i386' &&
		"$dist_name-$dist_version" != 'debian-9' &&
		"$dist_name-$dist_version" != 'debian-10' &&
		"$dist_name-$dist_version" != 'ubuntu-1804'
	)
	|| $dist_arch == 'x86_64' || $dist_arch == 'arm64' || $dist_arch == 'armhf' || $dist_arch == 'ppc64le') && (
	($dist_name == 'debian'   && $dist_version >= 9) ||
	($dist_name == 'raspbian' && $dist_version >= 9) ||
	($dist_name == 'ubuntu'   && $dist_version >= 1804)
);

$build_web_service = ($dist_arch != "ppc64le") && ($zbx_version >= 5.3) && ($dist_arch == 'x86_64' || $dist_arch == 'arm64' || $dist_arch == 'armhf') && (
	($dist_name == 'debian'   && $dist_version >= 10) ||
	($dist_name == 'raspbian' && $dist_version >= 10) ||
	($dist_name == 'ubuntu'   && $dist_version >= 1804)
);

$build_proxy = ($dist_arch != "ppc64le") && (
	($zbx_version <= 5.0) ||
	($zbx_version <= 6.4 && $dist_name == 'debian'   && $dist_version >= 10)   ||
	($zbx_version <= 6.4 && $dist_name == 'raspbian' && $dist_version >= 10)   ||
	($zbx_version <= 6.4 && $dist_name == 'ubuntu'   && $dist_version >= 1804) ||
	($zbx_version >= 6.5 && $dist_name == 'ubuntu'   && $dist_version >= 2004) ||
	($zbx_version >= 6.5 && $dist_name == 'debian'   && $dist_version >= 11)   ||
	($zbx_version >= 6.5 && $dist_name == 'raspbian' && $dist_version >= 11)
);

$build_java_gateway = $build_proxy;

$build_frontend = $build_server = ($dist_arch != "ppc64le") && (
	($zbx_version <= 5.0)                                                       ||
	($zbx_version <= 6.0 && $dist_name == 'debian'   && $dist_version >= 10)    ||
	($zbx_version <= 6.0 && $dist_name == 'raspbian' && $dist_version >= 10)    ||
	($zbx_version <= 6.0 && $dist_name == 'ubuntu'   && $dist_version >= 1804)  ||
	($zbx_version <= 6.4 && $dist_name == 'debian'   && $dist_version >= 11)    ||
	($zbx_version <= 6.4 && $dist_name == 'raspbian' && $dist_version >= 11)    ||
	($zbx_version <= 6.4 && $dist_name == 'ubuntu'   && $dist_version >= 2004)  ||
	($zbx_version >= 6.5 && $dist_name == 'debian'   && $dist_version >= 12)    ||
	($zbx_version >= 6.5 && $dist_name == 'raspbian' && $dist_version >= 12)    ||
	($zbx_version >= 6.5 && $dist_name == 'ubuntu'   && $dist_version >= 2204)
);

if ($zbx_version <= 5.0 && $dist_name == 'ubuntu' && $dist_version >= 2204)
{
    $build_frontend = $build_server = false;
}

$build_js = ($build_server || $build_proxy) && ($zbx_version >= 5.0);

$build_sql_scripts =
	($zbx_version >= 5.3) && ($build_proxy || $build_server);

$new_style_sql_scripts =       # This is needed in rules.tmpl.php for determinig sql file names and for override_dh_compress
	($zbx_version >= 5.5); # If set, then will create (server,proxy).sql files, otherwise will produce create.sql files.

$add_php_mod_deps = $build_frontend && (
	($dist_name == 'debian' && ($dist_version >= 9 || $zbx_version >= 4.5)) ||
	($dist_name == 'raspbian') ||
	($dist_name == 'ubuntu' && $dist_version >= 1604)
);

$build_web_conf =
	$build_frontend && $zbx_version >= 5.0;

$web_is_deprecated = ($zbx_version == 5.0) && (
	($dist_name == 'debian'   && $dist_version <= 9) ||
	($dist_name == 'raspbian' && $dist_version <= 9) ||
	($dist_name == 'ubuntu'   && $dist_version <= 1604)
);

$frontend_deps = '';
$frontend_deps_database  = 'php-mysql | php-pgsql';
$frontend_deps_mbstring  = 'php-mbstring';
$frontend_deps_bcmath    = 'php-bcmath';
$frontend_deps_xml       = 'php-xml';
$frontend_deps_gd        = 'php-gd';
$frontend_deps_ldap      = 'php-ldap';

if (!$build_web_conf)
	$frontend_deps .= "php | libapache2-mod-php,\n apache2 | httpd,\n";

$frontend_deps .= " $frontend_deps_database,\n";

if ($add_php_mod_deps)
	$frontend_deps .= " $frontend_deps_mbstring, $frontend_deps_bcmath, $frontend_deps_xml,";

$frontend_deps .= " $frontend_deps_gd, $frontend_deps_ldap,";

if ($zbx_version >= 6.5)
	$frontend_deps .= " php-curl,";

$frontend_deps .= "\n";

$frontend_deps .= " fonts-dejavu | ttf-dejavu-core | ttf-japanese-gothic\n";

$use_libsnmp = ($dist_arch != "ppc64le");

$use_agent2_plugins = (
	($dist_arch == 'x86_64' && $dist_name == 'ubuntu' && $dist_version >= 1804) ||
	($dist_arch == 'x86_64' && $dist_name == 'debian' && $dist_version >= 9) ||
	($dist_name == 'raspbian' && $dist_version >= 9) ||
	($dist_arch == 'arm64' && $dist_name == 'ubuntu' && $dist_version >= 2004)
);

$explicit_agent2_plugin_dependency =
	($zbx_version == 6.0);

?>
