/*
** Zabbix
** Copyright (C) 2001-2025 Zabbix SIA
**
** Licensed under the Apache License, Version 2.0 (the "License");
** you may not use this file except in compliance with the License.
** You may obtain a copy of the License at
**
**     http://www.apache.org/licenses/LICENSE-2.0
**
** Unless required by applicable law or agreed to in writing, software
** distributed under the License is distributed on an "AS IS" BASIS,
** WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
** See the License for the specific language governing permissions and
** limitations under the License.
**/

package params

import "golang.zabbix.com/sdk/metric"

const (
	// DeviceUUIDParamName device UUID parameter name.
	DeviceUUIDParamName = "deviceUUID"
)

//nolint:gochecknoglobals // global constants.
var (
	// Params groups all base parameters common for all connections.
	Params = []*metric.Param{DeviceUUID}

	// DeviceUUID is device UUID parameter.
	DeviceUUID = metric.NewParam(DeviceUUIDParamName, "Device UUID to get information from.").SetRequired()
)
